#!/bin/bash

# Test conjecture that every bridgeless cubic graph has
# at least 2^{n/2 - 1} circuit double covers on all
# graphs up to 18 vertices. We know that minimal
# counterexample does not have 3 or 4-cycle so we skip
# those.

export PYTHONUNBUFFERED=x

for i in 4 6 8 10 12 14 16 18; do
  geng -Ctfd3D3 $i
done |
nice sage -python3 ../count_cdc.py > ${0%.sh}.log

