#!/usr/bin/python

"""
  Calculate the number of circuit double covers for the Petersen
  graph and Blanusa snarks.
"""

import _experiment
from graph_tools.all import *
from sage.all import graphs

L = {
  "Petersen graph": graphs.PetersenGraph(),
  "Blanusa first snark": graphs.BlanusaFirstSnarkGraph(),
  "Blanusa second snark": graphs.BlanusaSecondSnarkGraph(),
}

if __name__ == "__main__":
  for n, g in L.items():
    print("%s: %i" % (n, graph_to_gadget(g).eval(CircuitDoubleCover)))

