#!/usr/bin/python

"""
  Calculate which members of the graph family from Theorem 7.6
  are snarks.
"""

import _experiment
from itertools import permutations
from graph_tools.all import *
import json

template = [10, [
  [0, 1], [1, 2], [1, 3], [2, 6], [2, 9], [3, 7],
  [3, 8], [4, 5], [4, 6], [4, 9], [5, 7], [5, 8],
  [6, 7], [8, 9], [0, 0]
]]

assignment = [0, 0, 0, 0, 0, 0, 0, 2, 2, 0, -2, 0, 0, 0, 1]

Seq = voltage_graph_zn_to_sequence(template, assignment)

if __name__ == "__main__":
  for i in range(3, 12):
    G = Seq.graph(i).eval(UnderlyingGraph)
    print(json.dumps({
      "i": i,
      "graph": G.sparse6_string()
    }))

  X = Seq.stabilize(EdgeColoring(3))
  p, l = stabilize_period(X, shift=1)
  print(p, l, l[p:])

