#!/usr/bin/python

"""
  Derive a formula for the number of circuit double covers
  of cyclic ladders and crossed cyclic ladders.
"""

import _experiment
from graph_tools.all import *

L = CyclicLadder().stabilize(CircuitDoubleCover, jordan=True)
CL = CyclicLadder(True).stabilize(CircuitDoubleCover, jordan=True)

if __name__ == "__main__":
  print("Cyclic ladders:\n  Formula: %s\n  Under the condition %s\n" %
    (L["formula"], L["formula_if"]))
  print("Crossed cyclic ladders:\n  Formula: %s\n  Under the condition %s" %
    (CL["formula"], CL["formula_if"]))
