#!/usr/bin/python

"""
  Derive a formula for the number of circuit double covers of a flower.

  Let $G$ be embedding of a graph into some surface. We say that a face
  $f$ of size $k$ together with its neighbour faces are a {\em $k$-flower
  with center $f$} given that $k \geq 3$, $f$ shares exactly one edge
  with each of its neighbour faces, consecutive neighbour faces also
  share exactly one edge, and non-consecutive neighbour faces do not
  share any edge.
"""

import _experiment
from graph_tools.all import *

@GraphSequence
class Flower:
  """
  >>> all( cdc_count(Flower.graph(k)) == (2**(k-1) + (-1)**k) // 3 + 1 for k in range(3, 20) )
  True
  >>> Flower.stabilize(CircuitDoubleCover, 2)['formula']
  Loop 1 done - 3 boundaries (0 new)
  1/3*2^(k - 1) + 1/3*(-1)^k + 1
  """
  sequence_start = 2

  SCV = FakeGadget(3, [ BoundaryValue(((1,), (2,), (1, 2), None), 1) ])

  D = Gadget.join(
    [ SCV, CUBIC_VERTEX ],
    [ ((1,3), (2,3)) ],
    [ (1,1), (2,1), (2,2), (1,2) ]
  )

  step_join = [ ((1,3), (2,2)), ((1,4), (2,1)) ]
  step_out = [ (1,1), (1,2), (2,3), (2,4) ]
  final_join = [ ((1,1), (1,4)), ((1,2), (1,3)) ]

  base_gadget = Gadget.join([D, D], step_join, step_out)
  step_gadget = D

if __name__ == "__main__":
  print(Flower.stabilize(CircuitDoubleCover))

