import numpy as np
import matplotlib.pyplot as plt
import math

# Triviální příklad: jedna křivka
def example1():
    x = np.linspace(0, 2, 100)
    plt.plot(x, x ** 2)
    plt.show()

# Graf se dvěma křivkami a popsanými osami
def example2():
    x = np.linspace(0, 2, 100)
    plt.plot(x, x ** 2, label="quadratic")
    plt.plot(x, x ** 3, label="cubic")
    plt.xlabel("Čas")
    plt.ylabel("Počet svišťů")
    plt.title("Svišti na cvičišti")
    plt.legend()
    plt.show()
    # plt.savefig("figure.pdf")

# Různé styly bodů a čar
def example3():
    x = np.linspace(0, 2, 10)
    plt.plot(x, x, 'ro-', label="linear")          # Red, dots, line
    plt.plot(x, x ** 2, 'b--', label="quadratic")  # Blue, dashed line
    plt.plot(x, x ** 3, 'g^', label="cubic")       # Green, triangles
    plt.plot(x, x ** 4, 'ko-', markersize=10, linewidth=4, label="quartic")  # Heavy line, big markers
    plt.legend()
    plt.show()

# Schodiště
def example4():
    n = 32
    x = np.linspace(0, 2*math.pi, n)
    plt.plot(x, np.sin(x), 'o-', color='grey', alpha=0.5)
    plt.step(x, np.sin(x), where='pre')   # or "mid" or "post"
    plt.show()

# Sloupcový graf
def example5():
    x = np.linspace(0, math.pi, 10)
    y = np.sin(x)
    plt.bar(x, y, color='blue', edgecolor='black', width=0.2)
    plt.show()

# Histogram
def example6():
    r = np.random.random_sample(100)
    plt.hist(r, bins=10, range=(0.,1.), edgecolor='black')
    plt.show()

# Plocha mezi dvěma křivkami
def example7():
    x = np.linspace(0, 2, 100)
    plt.fill_between(x, x**2, x**3)
    plt.show()

# Polární souřadnice: srdovka
def example8():
    phi = np.linspace(0, 2*math.pi, 100)
    r = 1 - np.cos(phi)
    plt.polar(phi, r)
    plt.show()

# Logaritmické osy
def example9():
    x = np.linspace(0, 10, 100)
    y = 2**x
    # plt.plot(x, y)
    plt.semilogy(x, y)
    # plt.loglog(x, y)
    plt.show()

# Styl "od ruky" po vzoru xkcd.com
def example10():
    x = np.linspace(0, 2, 20)
    plt.xkcd()
    plt.plot(x, x ** 2, label="quadratic")
    plt.plot(x, x ** 3, label="cubic")
    plt.xlabel("Čas")
    plt.ylabel("Počet svišťů")
    plt.title("Svišti na cvičišti")
    plt.legend()
    plt.show()

# Doplněné čáry s popiskami
def example11():
    x = np.linspace(0, 2, 100)
    plt.plot(x, x ** 2)
    plt.hlines([1., 2.], xmin=0., xmax=2.)
    plt.vlines([1.], ymin=0., ymax=3.)
    plt.text(0.1, 1.05, "y=1", fontsize=24)
    plt.annotate("y=2", (0.1, 2.05), xytext=(0.15, 2.2), arrowprops={'arrowstyle': '->'}, fontsize=24)
    plt.show()

# Více grafů v jednom obrázku
def example12():
    x = np.linspace(0, 2, 100)
    plt.subplot(221)    # zkratka za (2, 2, 1), což je (#řádků, #sloupců, kolikátý)
    plt.plot(x, x)
    plt.subplot(222)
    plt.plot(x, x**2)
    plt.subplot(223)
    plt.plot(x, x**3)
    plt.subplot(224)
    plt.plot(x, x**4)
    plt.show()

# Sdílení os
def example13():
    x = np.linspace(0, 10, 1000)
    ax = plt.subplot(311)
    plt.plot(x, np.sin(2*math.pi*x))
    plt.subplot(312, sharex=ax, sharey=ax)
    plt.plot(x, 0.5*np.sin(3*math.pi*x))
    plt.subplot(313, sharex=ax, sharey=ax)
    plt.plot(x, 0.7*np.sin(5*math.pi*x))
    plt.show()

# Objektové rozhraní
def example14():
    # Založíme obrázek
    fig, ax = plt.subplots()
    # fig je typu Figure (celý obrázek)
    # ax typu Axes (to je jeden graf)

    # Nastavíme globální vlastnosti obrázku
    fig.set_facecolor('#ccccff')

    # Nakreslíme křivku
    x = np.linspace(0, 5, 1000)
    p, = ax.plot(x, np.cos(2*math.pi*x))  # tuple -> p je typu matplotlib.lines.Line2D

    # Nastavíme vlastnosti křivky
    p.set_color('red')
    p.set_linewidth(2)

    # Upravíme textové objekty s čísly u značek na ose x
    for tick in ax.get_xticklabels():
        tick.set_rotation(55)

    plt.show()

example1()